#include "std.mi"

Function fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH);

Global Group	grpMain;
Global Group	grpAniItem02;
Global AnimatedLayer	ani02Drug;
Global int	intWPosX;
Global int	intWPosY;
Global int	intObjH;
Global int	intObjW;
Global Boolean	blnDrg;

System.onScriptLoaded(){

	grpMain 	= getScriptGroup();
	grpAniItem02	= grpMain.getObject("VuMeter.Group");
	ani02Drug	= grpAniItem02.getObject("VuMeter");
	intWPosX	= System.getPrivateInt("Love-Live", "WPosX", 0);
	intWPosY	= System.getPrivateInt("Love-Live", "WPosY", 0);
	intObjW		= grpAniItem02.getGuiW();
	intObjH		= grpAniItem02.getGuiH();

	fn_ReSizeGroup(grpAniItem02, intWPosX, intWPosY, intObjW, intObjH, 0.1, 0.1);
//	fn_ReSizeGroup(grpAniItem02, 0, 0, intObjW, intObjH, 0.1, 0.1, 255);
}

System.onScriptUnloading(){

	System.setPrivateInt("Love-Live", "WPosX", intWPosX);
	System.setPrivateInt("Love-Live", "WPosY", intWPosY);
}

ani02Drug.onLeftButtonDown(int x, int y) {


	blnDrg = 1;

	intWPosX = grpAniItem02.getLeft() - x;
	intWPosY = grpAniItem02.getTop() - y;
}

ani02Drug.onLeftButtonUp(int x, int y) {

	blnDrg = 0;

	if (ani02Drug.getLeft() < 0) {
	  grpAniItem02.setXmlParam("x", "0");
	} else if (ani02Drug.getLeft() + ani02Drug.getWidth() > 400) {
	  grpAniItem02.setXmlParam("x", integerToString(400 - ani02Drug.getWidth()));
	}

	if (ani02Drug.getTop() < 22) {
	  grpAniItem02.setXmlParam("y", "22");
	} else if (ani02Drug.getTop() + ani02Drug.getHeight() > 422) {
	  grpAniItem02.setXmlParam("y", integerToString(422 - ani02Drug.getHeight()));
	}

	intWPosX = grpAniItem02.getLeft();
	intWPosY = grpAniItem02.getTop();
}

ani02Drug.onMouseMove(int x, int y) {

	if (!blnDrg) return;

	grpAniItem02.setXmlParam("x", integerToString(x + intWPosX));
	grpAniItem02.setXmlParam("y", integerToString(y + intWPosy));
}

fn_ReSizeGroup(Group g, int TargetX, int TargetY, int TargetW, int TargetH, Float SpeedW, Float SpeedH){

	g.setTargetX(TargetX);
        g.setTargetY(TargetY);
        g.setTargetW(TargetW);
        g.setTargetH(TargetH);
        g.setTargetSpeed(SpeedW);
        g.setTargetSpeed(SpeedH);
        g.gotoTarget();
}