#include "std.mi"

Function UpdateVis(Int Frame);
Function Fn_StartAnim(AnimatedLayer l, int start, int end, int speed);

Global Group		grpMain;
Global Group		grpRepBtn;
Global Group		grpAnibtnVuMeter;
Global AnimatedLayer	anibtnVuMeter;
Global int 		intVuMeterState;
Global int 		intVuMeterState2;

Global Group		grpVuMeter;
Global Timer		VisTimer;
Global Double		Level, OneFrame;
Global Int		LastFrame;
Global AnimatedLayer	aniVu1;

Global Group		grpVis;


System.onScriptLoaded() {

	grpMain 		= getScriptGroup();
	grpRepBtn		= grpMain.findObject("PlMlVdButtons.Group");
	grpAnibtnVuMeter	= grpRepBtn.findObject("VuMeter_button.Group");
	anibtnVuMeter		= grpAnibtnVuMeter.findObject("VuMeter_button");
	grpVuMeter		= grpMain.findObject("VuMeter.Group");
	intVuMeterState		= System.getPrivateInt("Love-Live", "VuState", 0);
	intVuMeterState2	= System.getPrivateInt("Love-Live", "VuState2", 0);

	grpVis			= grpMain.findObject("Visualzation.Group");

	aniVu1		= grpVuMeter.findObject("VuMeter");


	VisTimer = new Timer;
	VisTimer.setDelay(50);
	VisTimer.start();

	if(intVuMeterState == 0) {

		grpVuMeter.Show();
		grpVis.Show();

		VisTimer.stop();
		VisTimer.setDelay(50);
		VisTimer.start();
	}

	else if(intVuMeterState == 1) {

		grpVuMeter.Show();
		grpVis.Hide();

		VisTimer.stop();
		VisTimer.setDelay(50);
		VisTimer.start();

	}
	else if(intVuMeterState == 2) {

		grpVuMeter.Hide();
		grpVis.Show();

		VisTimer.stop();
	}
	else if(intVuMeterState == 3) {

		grpVuMeter.Hide();
		grpVis.Hide();

		VisTimer.stop();
	}

	if(intVuMeterState2 == 0) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);
	if(intVuMeterState2 == 1) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);
	if(intVuMeterState2 == 2) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);
	if(intVuMeterState2 == 3) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);

	aniVu1.setSpeed(50);
	OneFrame = 255/(aniVu1.getLength());

}

System.onScriptUnloading() {

	System.setPrivateInt("Love-Live", "VuState", intVuMeterState);
	System.setPrivateInt("Love-Live", "VuState2", intVuMeterState2);

	VisTimer.stop();
    	delete VisTimer;

}

anibtnVuMeter.onEnterArea(){

	if(intVuMeterState2 == 0) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);
	if(intVuMeterState2 == 1) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);
	if(intVuMeterState2 == 2) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);
	if(intVuMeterState2 == 3) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);
}
anibtnVuMeter.onLeftButtonDown(int x, int y) {

	if(intVuMeterState2 == 0) Fn_StartAnim(anibtnVuMeter, 2, 2, 0);
	if(intVuMeterState2 == 1) Fn_StartAnim(anibtnVuMeter, 2, 2, 0);
	if(intVuMeterState2 == 2) Fn_StartAnim(anibtnVuMeter, 2, 2, 0);
	if(intVuMeterState2 == 3) Fn_StartAnim(anibtnVuMeter, 2, 2, 0);

}
anibtnVuMeter.onLeftButtonUp(int x, int y) {

	VisTimer.stop();

	Fn_StartAnim(anibtnVuMeter, 1, 1, 0);

	intVuMeterState ++;
	if(intVuMeterState >=4) intVuMeterState = 0;

	intVuMeterState2 ++;
	if(intVuMeterState2 >=4) intVuMeterState2 = 0;
	if(intVuMeterState == 0) {

		grpVuMeter.Show();
		grpVis.Show();

		VisTimer.stop();
		VisTimer.setDelay(50);
		VisTimer.start();
	}

	else if(intVuMeterState == 1) {

		grpVuMeter.Show();
		grpVis.Hide();

		VisTimer.stop();
		VisTimer.setDelay(50);
		VisTimer.start();
	}
	else if(intVuMeterState == 2) {

		grpVuMeter.Hide();
		grpVis.Show();

		VisTimer.stop();
	}
	else if(intVuMeterState == 3) {

		grpVuMeter.Hide();
		grpVis.Hide();

		VisTimer.stop();
	}

	if(intVuMeterState2 == 0) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);
	if(intVuMeterState2 == 1) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);
	if(intVuMeterState2 == 2) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);
	if(intVuMeterState2 == 3) Fn_StartAnim(anibtnVuMeter, 1, 1, 0);

}
anibtnVuMeter.onLeaveArea(){

	if(intVuMeterState2 == 0) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);
	if(intVuMeterState2 == 1) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);
	if(intVuMeterState2 == 2) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);
	if(intVuMeterState2 == 3) Fn_StartAnim(anibtnVuMeter, 0, 0, 0);
}

Fn_StartAnim(AnimatedLayer l, int start, int end, int speed){

	l.stop();
	l.setStartFrame(start);
	l.setEndFrame(end);
	l.setSpeed(speed);
	l.play();
}

VisTimer.onTimer() {

	Level = (System.getLeftVuMeter());
	UpdateVis(Level/OneFrame);

}

UpdateVis(Int Frame){

	aniVu1.setStartFrame(LastFrame);
	aniVu1.setEndFrame(Frame);
	aniVu1.play();
	LastFrame = Frame;
}
