Option Explicit

Dim cfg : Set cfg = WScript.CreateObject("Scripting.Dictionary")

cfg.Add "En", Array(4, -3, 100)
cfg.Add "Ja", Array(2, -1, 100)
  ' pp / {p
  '    - [0] ̍   (Pitch)  <:-10~0~10>
  '    - [1] ̑   (Rate)   <:-10~0~10>
  '    - [2] ̑傫 (Volume) <:0~100>

Main
Set cfg = Nothing

Sub Main()
    If 0 = WScript.Arguments.Count Then Exit Sub

    Dim oSpeak, nLangNumbers, sLang, i
    Set oSpeak       = WScript.CreateObject("SAPI.SpVoice")
    Set nLangNumbers = WScript.CreateObject("Scripting.Dictionary")

    For i = 0 To oSpeak.GetVoices().Count - 1
        If     0 < InStr(oSpeak.GetVoices().Item(i).GetDescription, "English")  Then
            nLangNumbers("En") = i
        ElseIf 0 < InStr(oSpeak.GetVoices().Item(i).GetDescription, "Japanese") Then
            nLangNumbers("Ja") = i
        End If
    Next
    If IsEmpty( nLangNumbers("En") ) Then nLangNumbers("En") = 0
    If IsEmpty( nLangNumbers("Ja") ) Then nLangNumbers("Ja") = nLangNumbers("En")

    If ContainsEm( WScript.Arguments(0) ) Then
        sLang = "Ja"
    Else
        sLang = "En"
    End If
    Set oSpeak.Voice = oSpeak.GetVoices().Item( nLangNumbers(sLang) )
    oSpeak.Rate   = cfg(sLang)(1)
    oSpeak.Volume = cfg(sLang)(2)
    oSpeak.Speak "<pitch middle='" & cfg(sLang)(0) & "'>" _
                            & WScript.Arguments(0) & "</pitch>"

    Set oSpeak       = Nothing
    Set nLangNumbers = Nothing
End Sub

Function ContainsEm( ByVal s )
    Dim i
    ContainsEm = False
    For i = 0 To Len(s) - 1
        If 0 <> ( Asc( Mid(s, i+1, 1) ) And &HFF00 ) Then
            ContainsEm = True
            Exit For
        End If
    Next
End Function
