function ExistsFileDropped()
    local f = io.open( SKIN:GetMeasure('msDropPath'):GetStringValue() )
    if f then
        f:close()
        SKIN:Bang('!SetVariable', '_fDropExistsFile', 1)
    else
        SKIN:Bang('!SetVariable', '_fDropExistsFile', 0)
    end
end

function IsFileDropped()
    local f = io.open( SKIN:GetMeasure('msDropPath'):GetStringValue() )
    if f then
        f:close()
        SKIN:Bang('!SetVariable', '_fDropIsFile', 1)
    else
        SKIN:Bang('!SetVariable', '_fDropIsFile', 0)
    end
end

function CalcReduction()
    local function GetGreatestCommonDivisor( p1, p2 )
        local n1 = p1
        local n2 = p2
        if 0 ~= n2 then n1 = GetGreatestCommonDivisor(n2, n1%n2) end
        return n1
    end
    local s   = SKIN:GetMeasure('msFormula'):GetStringValue()
    local n1  = string.match(s, '%d+%.?%d*')
    local n2  = string.match(s, '%d+%.?%d*$')
    local gcd = GetGreatestCommonDivisor(n1, n2)
    SKIN:Bang('!SetVariable', '_answer', n1/gcd..' : '..n2/gcd..' ('..gcd..')')
end
