function AddComma()
    local comma = tonumber(SKIN:GetVariable('comma', 3))
    local n
    local i
    if 3 <= comma then
        n = _Split(SKIN:GetVariable('_answer'), '%.')
        if 1 < #n then
            SKIN:Bang('!SetVariable', '_answer', _Separate(n[1], -comma)..'.'..n[2])
        else
            SKIN:Bang('!SetVariable', '_answer', _Separate(n[1], -comma))
        end
    end
end

function CalcReduction()
    local function GetGreatestCommonDivisor( p1, p2 )
        if 0 ~= p2 then p1 = GetGreatestCommonDivisor(p2, p1%p2) end
        return p1
    end
    local s   = SKIN:GetMeasure('msFormula'):GetStringValue()
    local n1  = string.match(s, '%d+%.?%d*')
    local n2  = string.match(s, '%d+%.?%d*$')
    local gcd = GetGreatestCommonDivisor(n1, n2)
    SKIN:Bang('!SetVariable', '_answer', n1/gcd..' : '..n2/gcd..' ('..gcd..')')
end

function CalcBaseN()
    local n = SKIN:GetMeasure('msFormula'):GetStringValue()
    local tResult = {}
    local tLen    = {}
    if nil == string.match(n, '^%d+$') then
        tResult[1] = '--' ; tResult[2] = '--' ; tResult[3] = '--'
    else
        tResult[1] = string.upper(string.format('%x', n))
        tResult[2] = string.format('%o', n)
        tResult[3] = _Conv10to2(n)
    end
    tResult[4] = tonumber(n, 16)
    if nil == tResult[4] then tResult[4] = '--' end
    tResult[5] = tonumber(n, 8)
    if nil == tResult[5] then tResult[5] = '--' end
    tResult[6] = tonumber(n, 2)
    if nil == tResult[6] then tResult[6] = '--' end
    tLen[1] = math.max(string.len(tResult[1]), string.len(tResult[4]))
    tLen[2] = math.max(string.len(tResult[2]), string.len(tResult[5]))
    SKIN:Bang('!SetVariable', '_answer',
              '10->16 : '..string.format('%-'..tLen[1]..'s', tResult[1])..
              '  /  10->8 : '..string.format('%-'..tLen[2]..'s', tResult[2])..
              '  /  10->2 : '..tResult[3]..'#CRLF#'..
              '16->10 : '..string.format('%-'..tLen[1]..'s', tResult[4])..
              '  /  8->10 : '..string.format('%-'..tLen[2]..'s', tResult[5])..
              '  /  2->10 : '..tResult[6]..'#CRLF# original number : '..n)
end

function CalcFactorial()
    local comma = tonumber(SKIN:GetVariable('comma', 3))
    local x = 1
    local n
    local i
    for i=2, tonumber(string.match(SKIN:GetMeasure('msFormula')
                                   :GetStringValue(), '(%d+)!')) do
        x = x * i
    end
    n = _Split(x, '%.')
    if 1 < #n then
        SKIN:Bang('!SetVariable', '_answer', _Separate(n[1], -comma)..'.'..n[2])
    else
        SKIN:Bang('!SetVariable', '_answer', _Separate(n[1], -comma))
    end
end

function _Conv10to2( i10 ) --[[
 Summary | 10進数(i10)を、2進数に変換する。
   Param | i10 : number … 対象の正の整数 (10進数)  ※マイナスや小数はＮＧ
  Return | string … 2進数に変換された値 (文字列)
    Note | ・引数が想定した値かどうかは判定していない。
         | ・文字列で返すのは、1e+14 のような表記になるのを防ぐため。 ]]
    local s2 = ''
    local iTemp
    while true do
        iTemp = tonumber(_Split(i10 * 0.5, '%.')[1])
        s2    = tostring(i10 - iTemp * 2)..s2
        if 0 == iTemp then break end
        i10 = iTemp
    end
    return s2
end

function _Split( str, sep ) --[[
 Summary | 文字列(str)を、区切り文字列(sep)で分割する。
   Param | str : string … 対象の文字列
         | sep : string … 区切り文字列 (正規表現)  ※正規表現なことに注意
  Return | table (string) … 分割された文字列が格納された配列
    Note | ・末尾が区切り文字列(sep)の場合、最後の要素(空)は作らない。
         |    → _Split('/a/b//c/', '/')  --> {'', 'a', 'b', '', 'c'} ]]
    if '' == sep then return {str} end
    local t = {}
    local s
    for s in string.gmatch(str, '.-'..sep) do
        t[#t+1] = string.gsub(s, sep, '')
    end
    if 0 < #t then
        s = string.match(str, '.*'..t[#t]..sep..'(.+)')
        if nil ~= s and nil == string.match(s, sep) then t[#t+1] = s end
    else
        t = {str}
    end
    return t
end

function _Separate( str, len, sep ) --[[
 Summary | 文字列(str)を、指定数(len)ごとに 区切り文字(sep)で区切る。
   Param | str : string … 対象の文字列
         | len : number … 区切る文字数  ※マイナスだと後ろから行う
         | sep : string … 区切り文字列 [nil=',']
  Return | string … 区切られた文字列
    Note | ・指定数(len)がマイナスだと、後ろから区切る。
         |    → _Separate('abcde',  3, '/')  --> 'abc/de'
         |    → _Separate('abcde', -3, '/')  --> 'ab/cde' ]]
    sep = sep or ','
    local result = ''
    local behind = len < 0 and true or false
    local i
    if 0 == len then
        result = str
    else
        if behind then
            str = string.reverse(str)
            len = len * -1
        end
        for i=1, string.len(str), len do
            result = result..sep..string.sub(str, i, i+len-1)
        end
        result = string.sub(result, string.len(sep)+1)
        if behind then result = string.reverse(result) end
    end
    return result
end
